# Ear Candy - Pulseaduio sound managment tool
# Copyright (C) 2008 Jason Taylor
# 
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import sys
try:
     import pygtk
     pygtk.require("2.0")
except:
      pass
try:
    import gtk
    import gtk.glade
except:
    sys.exit(1)

import re
import copy

from glade_window import GladeWindow
from window.WindowWatcher import WindowWatcher
from Client import Client

class EarCandyAppSelect(GladeWindow):
    def __init__(self, core):
        
        self.core = core
        
        GladeWindow.__init__(self, "pulseoptions.glade", "dialog_select")
        
        self.combobox_clients = self.wtree.get_widget("combobox_clients")
        self.treeview_applications = self.wtree.get_widget("treeview_applications")
        self.combobox_category = self.wtree.get_widget("combobox_category")

        signals = {
            "on_button_add_clicked" : self.on_button_add_clicked,
            "on_button_cancel_clicked" : self.on_button_cancel_clicked
        }
        self.wtree.signal_autoconnect(signals)
         
        # Setup tree
        column = gtk.TreeViewColumn((''))
        column.set_spacing(4)
        cell = gtk.CellRendererPixbuf()
        column.pack_start(cell, False)
        column.set_attributes(cell, pixbuf=0)
        self.treeview_applications.append_column(column)

        column = gtk.TreeViewColumn(('Application'))
        cell = gtk.CellRendererText()
        column.pack_start(cell, True)
        column.set_attributes(cell, markup=1)
        self.treeview_applications.append_column(column)
        self.store = gtk.ListStore(gtk.gdk.Pixbuf, str, object)
        self.treeview_applications.set_model(self.store) 
        self.store.set_sort_column_id(1, gtk.SORT_ASCENDING) 

        self.update()

    def append_window(self, state, pid, window_name, app_name, command, x, y, icon, fullscreen):

        client = Client(self.core, app_name)
        client.rule_re_application = re.compile(app_name)
        client.icon = icon

        iter = self.store.get_iter_first()
        while 1:
            if not iter: break
            if self.store.get_value(iter, 1) == app_name: return
            iter = self.store.iter_next(iter)

        self.store.append(([icon, app_name, client])) 
        
    def update(self):

        icon_theme = gtk.icon_theme_get_default()
        icon = icon_theme.lookup_icon("audio-volume-medium", 32, 0).load_icon()

        for client in self.core.get_unregistered_clients():
            self.combobox_clients.append_text(client.name)

        for app in self.core.ww.applications.values():
            self.store.append(([app.icon, app.name, app])) 

        self.combobox_clients.set_active(0)

        for val in self.core.display.values():
            self.combobox_category.append_text( val )

        self.combobox_category.set_active(0)

    def on_button_add_clicked(self, widget):

        client = self.core.pa_clients[self.combobox_clients.get_active_text()]
        

        # override with selected app
        model, iter =  self.treeview_applications.get_selection().get_selected()
        if not iter: return
        app = model.get_value(iter, 2)

        client.generate_rules(app.name)
        client.description = app.name
        client.icon = app.icon

        selected = self.combobox_category.get_active_text()
        for key in self.core.display.keys():
            if self.core.display[key] == selected:
                client.category = key
                break

        self.core.pref.update_client( client )
        self.stop()
    
    def on_button_cancel_clicked(self, widget):
        self.stop()
